#ifndef __AVMGAME_H
#define __AVMGAME_H

#include <iostream>
using std::cin;
#include <string>
using std::string;
#include <list>
using std::list;

struct Category {
    Category(string name="", string yesOrNoQuestion=""):
        name(name), yesOrNoQuestion(yesOrNoQuestion) {}
    string name;
    string yesOrNoQuestion;
    list<Category> subcategories;
};

class AVMGame: public Category {
private:
    void initialize();
    void addNewSubcategory(Category &category);
    void converseWithUser(Category &category, 
                            list<Category>::iterator nextTry);
public:
    AVMGame() { initialize(); }
    void converseWithUser() {
        converseWithUser(*this,subcategories.begin());
    }
};

class GameUtilities {
public:
    static bool answerIsYes() {
    string yesno;
    cin >> yesno;
        return yesno[0] == 'Y' || yesno[0] == 'y';
    }
    static void getStringFromUser(string prompt, string &answer);
};
    
#endif
